/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.lighting;

import cofh.repack.codechicken.lib.colour.ColourRGBA;
import cofh.repack.codechicken.lib.lighting.LC;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.vec.BlockCoord;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.world.IBlockAccess;

public class LightMatrix
implements CCRenderState.IVertexOperation {
    public static final int operationIndex = CCRenderState.registerOperation();
    public int computed = 0;
    public float[][] ao = new float[13][4];
    public int[][] brightness = new int[13][4];
    public IBlockAccess access;
    public BlockCoord pos = new BlockCoord();
    private int sampled = 0;
    private float[] aSamples = new float[27];
    private int[] bSamples = new int[27];
    public static final int[][] ssamplem = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8}, {18, 19, 20, 21, 22, 23, 24, 25, 26}, {0, 9, 18, 1, 10, 19, 2, 11, 20}, {6, 15, 24, 7, 16, 25, 8, 17, 26}, {0, 3, 6, 9, 12, 15, 18, 21, 24}, {2, 5, 8, 11, 14, 17, 20, 23, 26}, {9, 10, 11, 12, 13, 14, 15, 16, 17}, {9, 10, 11, 12, 13, 14, 15, 16, 17}, {3, 12, 21, 4, 13, 22, 5, 14, 23}, {3, 12, 21, 4, 13, 22, 5, 14, 23}, {1, 4, 7, 10, 13, 16, 19, 22, 25}, {1, 4, 7, 10, 13, 16, 19, 22, 25}, {13, 13, 13, 13, 13, 13, 13, 13, 13}};
    public static final int[][] qsamplem = new int[][]{{0, 1, 3, 4}, {5, 1, 2, 4}, {6, 7, 3, 4}, {5, 7, 8, 4}};
    public static final float[] sideao = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f, 0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f, 1.0f};

    public void locate(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        this.access = iBlockAccess;
        this.pos.set(n, n2, n3);
        this.computed = 0;
        this.sampled = 0;
    }

    public void sample(int n) {
        if ((this.sampled & 1 << n) == 0) {
            int n2 = this.pos.x + n % 3 - 1;
            int n3 = this.pos.y + n / 9 - 1;
            int n4 = this.pos.z + n / 3 % 3 - 1;
            Block block = this.access.getBlock(n2, n3, n4);
            this.bSamples[n] = this.access.getLightBrightnessForSkyBlocks(n2, n3, n4, block.getLightValue(this.access, n2, n3, n4));
            this.aSamples[n] = block.getAmbientOcclusionLightValue();
            this.sampled |= 1 << n;
        }
    }

    public int[] brightness(int n) {
        this.sideSample(n);
        return this.brightness[n];
    }

    public float[] ao(int n) {
        this.sideSample(n);
        return this.ao[n];
    }

    public void sideSample(int n) {
        if ((this.computed & 1 << n) == 0) {
            int[] nArray = ssamplem[n];
            for (int i = 0; i < 4; ++i) {
                int[] nArray2 = qsamplem[i];
                if (Minecraft.isAmbientOcclusionEnabled()) {
                    this.interp(n, i, nArray[nArray2[0]], nArray[nArray2[1]], nArray[nArray2[2]], nArray[nArray2[3]]);
                    continue;
                }
                this.interp(n, i, nArray[4], nArray[4], nArray[4], nArray[4]);
            }
            this.computed |= 1 << n;
        }
    }

    private void interp(int n, int n2, int n3, int n4, int n5, int n6) {
        this.sample(n3);
        this.sample(n4);
        this.sample(n5);
        this.sample(n6);
        this.ao[n][n2] = LightMatrix.interpAO(this.aSamples[n3], this.aSamples[n4], this.aSamples[n5], this.aSamples[n6]) * sideao[n];
        this.brightness[n][n2] = LightMatrix.interpBrightness(this.bSamples[n3], this.bSamples[n4], this.bSamples[n5], this.bSamples[n6]);
    }

    public static float interpAO(float f, float f2, float f3, float f4) {
        return (f + f2 + f3 + f4) / 4.0f;
    }

    public static int interpBrightness(int n, int n2, int n3, int n4) {
        if (n == 0) {
            n = n4;
        }
        if (n2 == 0) {
            n2 = n4;
        }
        if (n3 == 0) {
            n3 = n4;
        }
        return n + n2 + n3 + n4 >> 2 & 0xFF00FF;
    }

    @Override
    public boolean load() {
        if (!CCRenderState.computeLighting) {
            return false;
        }
        CCRenderState.pipeline.addDependency(CCRenderState.colourAttrib);
        CCRenderState.pipeline.addDependency(CCRenderState.lightCoordAttrib);
        return true;
    }

    @Override
    public void operate() {
        LC lC = CCRenderState.lc;
        float[] fArray = this.ao(lC.side);
        float f = fArray[0] * lC.fa + fArray[1] * lC.fb + fArray[2] * lC.fc + fArray[3] * lC.fd;
        int[] nArray = this.brightness(lC.side);
        CCRenderState.setColour(ColourRGBA.multiplyC(CCRenderState.colour, f));
        CCRenderState.setBrightness((int)((float)nArray[0] * lC.fa + (float)nArray[1] * lC.fb + (float)nArray[2] * lC.fc + (float)nArray[3] * lC.fd) & 0xFF00FF);
    }

    @Override
    public int operationID() {
        return operationIndex;
    }
}

